/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config;

import com.simibubi.create.foundation.block.BlockStressValues;
import com.simibubi.create.foundation.config.CClient;
import com.simibubi.create.foundation.config.CCommon;
import com.simibubi.create.foundation.config.CServer;
import com.simibubi.create.foundation.config.ConfigBase;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.api.ModLoadingContext;
import net.minecraftforge.api.fml.event.config.ModConfigEvents;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class AllConfigs {
    private static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    public static CClient CLIENT;
    public static CCommon COMMON;
    public static CServer SERVER;

    public static ConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends ConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            ConfigBase config = (ConfigBase)factory.get();
            config.registerAll((ForgeConfigSpec.Builder)builder);
            return config;
        });
        ConfigBase config = (ConfigBase)specPair.getLeft();
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)config;
    }

    public static void register() {
        CLIENT = AllConfigs.register(CClient::new, ModConfig.Type.CLIENT);
        COMMON = AllConfigs.register(CCommon::new, ModConfig.Type.COMMON);
        SERVER = AllConfigs.register(CServer::new, ModConfig.Type.SERVER);
        for (Map.Entry<ModConfig.Type, ConfigBase> pair : CONFIGS.entrySet()) {
            ModLoadingContext.registerConfig((String)"create", (ModConfig.Type)pair.getKey(), (IConfigSpec)pair.getValue().specification);
        }
        BlockStressValues.registerProvider("create", AllConfigs.SERVER.kinetics.stressValues);
        ModConfigEvents.loading((String)"create").register(AllConfigs::onLoad);
        ModConfigEvents.reloading((String)"create").register(AllConfigs::onReload);
    }

    public static void onLoad(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onLoad();
        }
    }

    public static void onReload(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onReload();
        }
    }
}

